/************************************************************************/
/*									*/
/*	SGL.H					(C) 1/94 Ch. Muenkel	*/
/*	Include file for libsgl.a library				*/
/*									*/
/************************************************************************/
/*									*/
/*	Simple Graphics Library						*/
/*	An easy to use interface to the X11 window system		*/
/*									*/
/************************************************************************/
/*									*/
/*	Author:	Christian Muenkel					*/
/*		Present address:					*/
/*		muenkel@carbo.tphys.uni-heidelberg.de			*/
/*		Christian Muenkel					*/
/*		Institut fuer Theoretische Physik			*/
/*		Philosophenweg 19					*/
/*		69120 Heidelberg - Germany				*/
/*									*/
/************************************************************************/
/* version      date            comment                                 */
/*                                                                      */
/* V1.0		 1/94		first implementation 			*/
/*                                                                      */
/************************************************************************/

#ifndef		__SGL_INCLUDED

#define		__SGL_INCLUDED

#include        <X11/Xlib.h>
#include        <X11/Xutil.h>


/************************************************************************/
/* global defines, which should be accesible from all modules		*/
/************************************************************************/
#ifndef	PI
#ifdef	M_PI
#define	PI	M_PI
#else
#define	PI	3.14159265358979323846
#endif
#endif

#define	VISTYPE_StaticGray		1
#define	VISTYPE_StaticColor		2
#define	VISTYPE_TrueColor		3
#define	VISTYPE_GrayScale		4
#define	VISTYPE_PseudoColor		5
#define	VISTYPE_DirectColor		6

#define	SGL_BLACK	0
#define	SGL_WHITE	1

/************************************************************************/
/* function declaration							*/
/************************************************************************/
void		sgl_init(void);
void		sgl_init_nowin(void);

void		sgl_viewport(float,float,float,float);
void		sgl_winsize(int,int);
void		sgl_display(void);
void		sgl_debugging(int);

int		sgl_colordef(char *);
void		sgl_color(int);
void		sgl_color_get_rgb(float*,float*,float*);
void		sgl_color_background(int);
void		sgl_create_colmap(void);

void		sgl_line(float,float,float,float);
void		sgl_circle(float,float,float);
void		sgl_disc(float,float,float);
void		sgl_rectangle(float,float,float,float);
void		sgl_rectarea(float,float,float,float);

void		sgl_put_ppm(char *, int, int);

int		sgl_create_win(int,int);
int		sgl_priv_create_win(int, int, Window);
void		sgl_delete_win(void);
int		sgl_set_win(Window,int,int);
void		sgl_select_win(int);
void		sgl_map_win(int);
void		sgl_unmap_win(int);
void		sgl_pos_win(int,int);
Window		sgl_get_windowid(int);

void		sgl_linewidth(int);

void		FatalError(char *);

#include        "sgl3d.h"

#endif
